/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.utils.CheckUtil;
import com.bxm.shopping.dal.entity.Mold;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.MoldDto;
import com.bxm.shopping.model.dto.MoldSearchDto;
import com.bxm.shopping.model.vo.MoldVo;
import com.bxm.shopping.service.IMoldService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mold"})
public class MoldController {
    @Autowired
    private IMoldService moldService;

    @GetMapping(value={"/page"})
    public ResponseModel<IPage<MoldVo>> page(MoldSearchDto moldSearchDto) {
        IPage page = this.moldService.page(moldSearchDto);
        return ResponseModelFactory.SUCCESS((Object)page);
    }

    @PostMapping(value={"/create"})
    public ResponseModel create(@RequestBody @Validated(value={ValidateGroups.Add.class}) MoldDto moldDto) {
        this.checkParam(moldDto);
        this.moldService.create(moldDto);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping(value={"/update"})
    public ResponseModel update(@RequestBody @Validated(value={ValidateGroups.Update.class}) MoldDto moldDto) {
        this.checkParam(moldDto);
        this.moldService.update(moldDto);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping(value={"/getById"})
    public ResponseModel getById(@RequestParam(value="id") Integer id) {
        Mold mold = (Mold)this.moldService.getById((Serializable)id);
        return ResponseModelFactory.SUCCESS((Object)mold);
    }

    @GetMapping(value={"/delete"})
    public ResponseModel delete(@RequestParam(value="id") Integer id) {
        this.moldService.delete(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping(value={"/updateStatus"})
    public ResponseModel updateStatus(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.moldService.updateStatus(id, status);
        return ResponseModelFactory.SUCCESS();
    }

    private void checkParam(MoldDto moldDto) {
        String moldConfig = moldDto.getConfig();
        CheckUtil.conditionCheck((boolean)StringUtils.isNotBlank((CharSequence)moldConfig), (String)"config\u4e0d\u80fd\u4e3a\u7a7a");
        List moldConfigs = JSONObject.parseArray((String)moldConfig, Mold.MoldConfig.class);
        for (Mold.MoldConfig config : moldConfigs) {
            CheckUtil.conditionCheck((boolean)StringUtils.isNotBlank((CharSequence)config.getSceneName()), (String)"sceneName\u4e0d\u80fd\u4e3a\u7a7a");
            CheckUtil.conditionCheck((boolean)StringUtils.isNotBlank((CharSequence)config.getSceneCoverImg()), (String)"sceneCoverImg\u4e0d\u80fd\u4e3a\u7a7a");
            CheckUtil.conditionCheck((boolean)Objects.nonNull(config.getSceneConfig()), (String)"sceneConfig\u4e0d\u80fd\u4e3a\u7a7a");
            for (Mold.SceneConfig sceneConfig : config.getSceneConfig()) {
                CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getType()), (String)"type\u4e0d\u80fd\u4e3a\u7a7a");
                CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getIsRequired()), (String)"isRequired\u4e0d\u80fd\u4e3a\u7a7a");
                CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getDescription()), (String)"description\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

