/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.bxm.shopping.common.enums.MarkStrategyEnum;
import com.bxm.shopping.common.enums.OrderType;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.common.utils.DateUtil;
import com.bxm.shopping.common.utils.EasyExcelUtil;
import com.bxm.shopping.common.utils.RegularUtils;
import com.bxm.shopping.model.query.UserOrderQuery;
import com.bxm.shopping.model.vo.ExprortOrderVo;
import com.bxm.shopping.model.vo.UserOrderVo;
import com.bxm.shopping.service.IUserOrderService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Resource
    IUserOrderService orderService;

    @RequestMapping(value={"/order/getPage"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity getPage(UserOrderQuery orderQuery) {
        orderQuery.setPlatform(UserOrderQuery.PLATFORM_OP);
        return ResponseEntity.ok((Object)this.orderService.getPage(orderQuery));
    }

    @RequestMapping(value={"/order/updateStatus"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity updateStatus(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.orderService.updateStatus(id, status);
        return ResponseEntity.ok((Object)"true");
    }

    @RequestMapping(value={"/order/export"}, method={RequestMethod.GET})
    public synchronized void export(HttpServletResponse response, UserOrderQuery orderQuery) {
        orderQuery.setPageNum(Integer.valueOf(1));
        orderQuery.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        orderQuery.setPlatform(UserOrderQuery.PLATFORM_OP);
        List list = this.orderService.getPage(orderQuery).getRecords();
        String fileName = DateUtil.dateTo81String((Date)new Date()) + "\u8ba2\u5355";
        ArrayList<ExprortOrderVo> exprortOrderVosList = new ArrayList<ExprortOrderVo>();
        for (UserOrderVo orderVo : list) {
            ExprortOrderVo exprortOrderVo = new ExprortOrderVo();
            BeanUtils.copyProperties((Object)orderVo, (Object)exprortOrderVo);
            exprortOrderVo.setOrderStatus(OrderType.getByCode((Integer)orderVo.getStatus()).getDesc());
            exprortOrderVo.setUserMobile(RegularUtils.encryptPhone((String)exprortOrderVo.getUserMobile()));
            exprortOrderVo.setProductStyle(StringUtils.replace((String)orderVo.getProductStyle(), (String)"&", (String)" \r\n"));
            exprortOrderVo.setIdCard("");
            exprortOrderVo.setPayTypeName(orderVo.getPayType() == null ? null : (orderVo.getPayType() == 1 ? "\u652f\u4ed8\u5b9d" : "\u5fae\u4fe1"));
            exprortOrderVo.setPayStatusName(orderVo.getPayStatus() == null ? null : (orderVo.getPayStatus() == 0 ? "\u672a\u652f\u4ed8" : "\u5df2\u652f\u4ed8"));
            String hitMarks = orderVo.getHitMarks();
            if (StringUtils.isNotBlank((CharSequence)hitMarks)) {
                String[] marks;
                StringBuilder sb = new StringBuilder();
                for (String mark : marks = hitMarks.split(",")) {
                    sb.append(MarkStrategyEnum.getNameByMarkType((Integer)Integer.parseInt(mark)));
                }
                exprortOrderVo.setHitMarks(sb.toString());
            }
            exprortOrderVo.setHitRiskWords(orderVo.getHitRiskWords());
            if (null != orderVo.getBehaviorType()) {
                Integer behaviorType = orderVo.getBehaviorType();
                switch (behaviorType) {
                    case 1: {
                        exprortOrderVo.setBehaviorType("\u5165\u5e93");
                        break;
                    }
                    case 2: {
                        exprortOrderVo.setBehaviorType("\u6fc0\u6d3b");
                        break;
                    }
                    case 3: {
                        exprortOrderVo.setBehaviorType("\u5145\u503c");
                        break;
                    }
                    case 4: {
                        exprortOrderVo.setBehaviorType("\u6076\u610f\u8ba2\u5355");
                        break;
                    }
                    default: {
                        exprortOrderVo.setBehaviorType(behaviorType.toString());
                    }
                }
            }
            exprortOrderVosList.add(exprortOrderVo);
        }
        EasyExcelUtil.write((HttpServletResponse)response, (String)fileName, ExprortOrderVo.class, exprortOrderVosList);
    }

    @RequestMapping(value={"/order/importOrder"}, method={RequestMethod.POST})
    public synchronized ResponseEntity importOrder(@RequestParam(value="file") MultipartFile file, @RequestParam(value="company") String company) {
        List orderVos = null;
        try {
            orderVos = EasyExcelUtil.read((InputStream)file.getInputStream(), ExprortOrderVo.class);
        }
        catch (IOException e) {
            throw new ShoppingException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            throw new ShoppingException("\u4e0d\u80fd\u5bfc\u5165\u7a7a\u6587\u4ef6");
        }
        log.info(orderVos.toString());
        return ResponseEntity.ok((Object)this.orderService.importOrder(orderVos, company, null));
    }

    @RequestMapping(value={"/order/getOrderInfo"}, method={RequestMethod.GET})
    public ResponseEntity getOrderInfo(Integer id) {
        return ResponseEntity.ok((Object)this.orderService.getOrderInfo(id));
    }

    @RequestMapping(value={"/order/batchCancel"}, method={RequestMethod.POST})
    public ResponseEntity batchCancel(@RequestParam(value="file") MultipartFile file) {
        List orderVos = null;
        try {
            orderVos = EasyExcelUtil.read((InputStream)file.getInputStream(), ExprortOrderVo.class);
        }
        catch (IOException e) {
            throw new ShoppingException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            throw new ShoppingException("\u4e0d\u80fd\u5bfc\u5165\u7a7a\u6587\u4ef6");
        }
        return ResponseEntity.ok((Object)this.orderService.batchCancel(orderVos, null));
    }

    @RequestMapping(value={"/order/updateSendStatus"}, method={RequestMethod.POST})
    public ResponseEntity updateSendStatus(@RequestParam(value="id") Integer id, @RequestParam(value="trackingNum") String trackingNum, @RequestParam(value="company") String company) {
        this.orderService.updateSendStatus(id, trackingNum, company);
        return ResponseEntity.ok((Object)true);
    }
}

