/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.bxm.shopping.common.generator.RedisLockGenerator;
import com.bxm.shopping.model.dto.PlatformConfigDto;
import com.bxm.shopping.model.vo.PlatformConfigVo;
import com.bxm.shopping.service.IPlatformConfigService;
import com.bxm.warcar.cache.impls.redis.DistributedRedisLock;
import com.bxm.warcar.utils.UUIDHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platformConfig"})
public class PlatformConfigController {
    @Autowired
    private IPlatformConfigService platformConfigService;
    @Autowired
    private DistributedRedisLock distributedRedisLock;

    @GetMapping(value={"/getByAdvertiserId"}, produces={"application/json"})
    public ResponseEntity getByAdvertiserId(@RequestParam(value="advertiserId") Integer advertiserId) {
        PlatformConfigVo vo = this.platformConfigService.getByAdvertiserId(advertiserId);
        return ResponseEntity.ok((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/savePlatformConfig"})
    public ResponseEntity savePlatformConfig(@Validated PlatformConfigDto dto) {
        String rid = UUIDHelper.generate();
        boolean tryLock = false;
        try {
            tryLock = this.distributedRedisLock.tryLock(RedisLockGenerator.getPlatformConfigSave((Integer)dto.getAdvertiserId()).generateKey(), rid);
            if (!tryLock) {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)"true");
                return responseEntity;
            }
            this.platformConfigService.savePlatformConfig(dto);
        }
        catch (Exception exception) {
        }
        finally {
            if (tryLock) {
                this.distributedRedisLock.unLock(RedisLockGenerator.getPlatformConfigSave((Integer)dto.getAdvertiserId()).generateKey(), rid);
            }
        }
        return ResponseEntity.ok((Object)"true");
    }
}

