/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.utils.CheckUtil;
import com.bxm.shopping.dal.entity.Mold;
import com.bxm.shopping.dal.entity.ProductComponent;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.ProductComponentDto;
import com.bxm.shopping.model.dto.ProductComponentSearchDto;
import com.bxm.shopping.model.vo.ProductComponentVo;
import com.bxm.shopping.service.IProductComponentService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/component"})
public class ProductComponentController {
    @Autowired
    private IProductComponentService productComponentService;

    @GetMapping(value={"/page"})
    public ResponseModel<IPage<ProductComponentVo>> page(ProductComponentSearchDto productComponentSearchDto) {
        IPage page = this.productComponentService.page(productComponentSearchDto);
        return ResponseModelFactory.SUCCESS((Object)page);
    }

    @PostMapping(value={"/create"})
    public ResponseModel create(@RequestBody @Validated(value={ValidateGroups.Add.class}) ProductComponentDto productComponentDto) {
        this.checkParam(productComponentDto);
        this.productComponentService.create(productComponentDto);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping(value={"/update"})
    public ResponseModel update(@RequestBody @Validated(value={ValidateGroups.Update.class}) ProductComponentDto productComponentDto) {
        this.checkParam(productComponentDto);
        this.productComponentService.update(productComponentDto);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping(value={"/getById"})
    public ResponseModel getById(@RequestParam(value="id") Integer id) {
        ProductComponent productComponent = (ProductComponent)this.productComponentService.getById((Serializable)id);
        return ResponseModelFactory.SUCCESS((Object)productComponent);
    }

    @GetMapping(value={"/delete"})
    public ResponseModel delete(@RequestParam(value="id") Integer id) {
        this.productComponentService.delete(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping(value={"/updateStatus"})
    public ResponseModel updateStatus(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.productComponentService.updateStatus(id, status);
        return ResponseModelFactory.SUCCESS();
    }

    private void checkParam(ProductComponentDto productComponentDto) {
        String config = productComponentDto.getConfig();
        CheckUtil.conditionCheck((boolean)StringUtils.isNotBlank((CharSequence)config), (String)"config\u4e0d\u80fd\u4e3a\u7a7a");
        List sceneConfigs = JSONObject.parseArray((String)config, Mold.SceneConfig.class);
        for (Mold.SceneConfig sceneConfig : sceneConfigs) {
            CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getType()), (String)"type\u4e0d\u80fd\u4e3a\u7a7a");
            CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getIsRequired()), (String)"isRequired\u4e0d\u80fd\u4e3a\u7a7a");
            CheckUtil.conditionCheck((boolean)Objects.nonNull(sceneConfig.getDescription()), (String)"description\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @GetMapping(value={"/tryLock"})
    public ResponseModel tryLock(@RequestParam(value="id") Integer id) {
        this.productComponentService.tryLock(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping(value={"/releaseLock"})
    public ResponseModel releaseLock(@RequestParam(value="id") Integer id) {
        this.productComponentService.releaseLock(id);
        return ResponseModelFactory.SUCCESS();
    }
}

