/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.shopping.common.enums.TemplateTypeEnum;
import com.bxm.shopping.common.redisson.LogBefore;
import com.bxm.shopping.common.utils.CheckUtil;
import com.bxm.shopping.dal.entity.Mold;
import com.bxm.shopping.dal.entity.Product;
import com.bxm.shopping.dal.entity.Template;
import com.bxm.shopping.model.dto.ProductDto;
import com.bxm.shopping.model.query.ProductQuery;
import com.bxm.shopping.model.vo.ProductNameAndIdVo;
import com.bxm.shopping.model.vo.ProductVo;
import com.bxm.shopping.service.IMoldService;
import com.bxm.shopping.service.IProductService;
import com.bxm.shopping.service.cache.TemplateCache;
import com.bxm.util.dto.ValidateException;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductController {
    private static final Logger log = LoggerFactory.getLogger(ProductController.class);
    @Resource
    IProductService productService;
    @Autowired
    private TemplateCache templateCache;
    @Autowired
    private IMoldService moldService;

    @PostMapping(value={"/product/sync/syncAllProduct"})
    public ResponseEntity<String> syncAllProduct(@RequestBody String data) {
        if (!data.equals("bxm-shopping")) {
            return ResponseEntity.status((int)500).body((Object)"\u9a8c\u8bc1\u5931\u8d25");
        }
        this.productService.syncAllProduct();
        return ResponseEntity.ok((Object)"true");
    }

    @PostMapping(value={"/product/sync/syncAllLp"})
    public ResponseEntity<String> syncAllLp(@RequestBody String data) {
        if (!data.equals("bxm-shopping")) {
            return ResponseEntity.status((int)500).body((Object)"\u9a8c\u8bc1\u5931\u8d25");
        }
        this.productService.syncAllLp();
        return ResponseEntity.ok((Object)"true");
    }

    @LogBefore(operType="/product/add", keyName="\u5546\u54c1\u65b0\u589e")
    @RequestMapping(value={"/product/add"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> add(HttpServletRequest request, HttpServletResponse response, @Validated @RequestBody ProductDto productDto) {
        this.checkParam(productDto);
        this.productService.addProduct(productDto);
        return ResponseEntity.ok((Object)"true");
    }

    @LogBefore(operType="/product/update", keyName="\u5546\u54c1\u7f16\u8f91")
    @RequestMapping(value={"/product/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> update(HttpServletRequest request, HttpServletResponse response, @Validated @RequestBody ProductDto productDto) {
        this.checkParam(productDto);
        this.productService.updateProduct(productDto);
        return ResponseEntity.ok((Object)"true");
    }

    @RequestMapping(value={"/product/getPage"}, produces={"application/json"})
    public ResponseEntity<Page<ProductVo>> getPage(HttpServletRequest request, HttpServletResponse response, ProductQuery productQuery) {
        return ResponseEntity.ok((Object)this.productService.getPage(productQuery));
    }

    private void checkParam(ProductDto productDto) {
        Boolean transIdCheck;
        if (Objects.nonNull(productDto.getTemplateId())) {
            Template template = this.templateCache.getTemplateById(productDto.getTemplateId());
            if (template == null) {
                throw new ValidateException("\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            if (!TemplateTypeEnum.NO_HEAD_IMG_TYPE.contains(template.getTemplateType()) && StringUtils.isBlank((String)productDto.getHeadImgs())) {
                throw new ValidateException("\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (productDto.getPlatformType() != null && (transIdCheck = Boolean.valueOf(productDto.getPlatformType() == 2 && StringUtils.isBlank((String)productDto.getTransId()))).booleanValue()) {
            throw new ValidateException("transId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer isMultiPrice = productDto.getIsMultiPrice();
        if (null != isMultiPrice && isMultiPrice == 1 && StringUtils.isBlank((String)productDto.getProductUnits())) {
            throw new ValidateException("productUnits\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet nameSet = Sets.newHashSet();
        int nameCount = 0;
        if (StringUtils.isNotBlank((String)productDto.getMultiProductConfig())) {
            List multiProducts = JSON.parseArray((String)productDto.getMultiProductConfig(), ProductDto.MultiProduct.class);
            for (ProductDto.MultiProduct multiProduct : multiProducts) {
                boolean needNameOrUrl;
                if (StringUtils.isBlank((String)multiProduct.getImg())) {
                    throw new ValidateException("\u7f3a\u5c11\u5546\u54c1\u914d\u7f6e\u56fe\u7247");
                }
                boolean bl = needNameOrUrl = StringUtils.isBlank((String)multiProduct.getName()) && StringUtils.isNotBlank((String)multiProduct.getUrl()) || StringUtils.isNotBlank((String)multiProduct.getName()) && StringUtils.isBlank((String)multiProduct.getUrl());
                if (needNameOrUrl) {
                    throw new ValidateException("\u7f3a\u5c11\u540d\u79f0\u6216url\u53c2\u6570");
                }
                if (!StringUtils.isNotBlank((String)multiProduct.getName())) continue;
                ++nameCount;
                nameSet.add(multiProduct.getName());
            }
        }
        if (StringUtils.isNotBlank((String)productDto.getLotteryConfig())) {
            ProductDto.LotteryConfig lotteryConfig = (ProductDto.LotteryConfig)JSON.parseObject((String)productDto.getLotteryConfig(), ProductDto.LotteryConfig.class);
            ProductController.conditionCheck(StringUtils.isNotBlank((String)lotteryConfig.getBackground()), "\u80cc\u666f\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(StringUtils.isNotBlank((String)lotteryConfig.getBestAward()), "\u6700\u5927\u5956\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(StringUtils.isNotBlank((String)lotteryConfig.getAward1()), "\u5956\u54c11\u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(StringUtils.isNotBlank((String)lotteryConfig.getAward2()), "\u5956\u54c12\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (nameSet.size() != nameCount) {
            throw new ValidateException("\u5546\u54c1\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        ProductDto.LimitStrategy limitStrategy = productDto.getLimitStrategy();
        if (null != limitStrategy) {
            ProductController.conditionCheck(StringUtils.isNotBlank((String)limitStrategy.getLimitPhoneValue()), "limitPhoneValue \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(StringUtils.isNotBlank((String)limitStrategy.getLimitIdCardValue()), "limitIdCardValue \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(null != limitStrategy.getLimitAddressStatus(), "limitAddressStatus \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(null != limitStrategy.getLimitNameStatus(), "limitNameStatus \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(null != limitStrategy.getLimitPhoneStatus(), "limitPhoneStatus \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(null != limitStrategy.getLimitIdCardStatus(), "limitIdCardStatus \u4e0d\u80fd\u4e3a\u7a7a");
            ProductController.conditionCheck(null != limitStrategy.getLimitIpBlackStatus(), "limitIpBlackStatus \u4e0d\u80fd\u4e3a\u7a7a");
            if (limitStrategy.getLimitPhoneValue().split("-").length != 2) {
                throw new ValidateException("limitPhoneValue\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
            }
            if (limitStrategy.getLimitIdCardValue().split("-").length != 2) {
                throw new ValidateException("limitIdCardValue\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (StringUtils.isNotBlank((String)productDto.getLimitOrderAdvertiserId())) {
            String limitOrderAdvertiserId = productDto.getLimitOrderAdvertiserId();
            try {
                Arrays.stream(limitOrderAdvertiserId.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.info(e.getMessage(), (Throwable)e);
                throw new ValidateException("\u8ba2\u5355\u9650\u5236\u591a\u5e7f\u544a\u4e3bid\u586b\u5199\u6709\u8bef");
            }
        }
        this.checkProductMold(productDto);
    }

    private void checkProductMold(ProductDto productDto) {
        Integer productType = productDto.getProductType();
        if (!Objects.equals(Product.PRODUCT_TYPE_INTERACTIVE, productType)) {
            return;
        }
        Integer moldId = productDto.getMoldId();
        ProductController.conditionCheck(Objects.nonNull(moldId), "moldId \u4e0d\u80fd\u4e3a\u7a7a");
        ProductController.conditionCheck(Objects.nonNull(productDto.getAdTag()), "adTag \u4e0d\u80fd\u4e3a\u7a7a");
        ProductController.conditionCheck(StringUtils.isNotBlank((String)productDto.getProductMoldConfig()), "productMoldConfig\u4e0d\u80fd\u4e3a\u7a7a");
        Mold mold = (Mold)this.moldService.getById((Serializable)moldId);
        ProductController.conditionCheck(Objects.nonNull(mold), "moldId \u4e0d\u5b58\u5728");
        if ((Objects.equals(mold.getStatus(), 0) || Objects.equals(mold.getDeleted(), 1)) && Objects.isNull(productDto.getId())) {
            throw new ValidateException("\u8be5\u5546\u54c1\u6a21\u677f\u5df2\u505c\u7528\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if ((Objects.equals(mold.getStatus(), 0) || Objects.equals(mold.getDeleted(), 1)) && Objects.equals(productDto.getStatus(), 2)) {
            throw new ValidateException("\u8be5\u5546\u54c1\u6a21\u677f\u5df2\u505c\u7528\uff0c\u65e0\u6cd5\u4e0a\u67b6");
        }
        String productMoldConfig = productDto.getProductMoldConfig();
        List productMoldConfigs = JSONObject.parseArray((String)productMoldConfig, Mold.ProductMoldConfig.class);
        if (CollectionUtils.isNotEmpty((Collection)productMoldConfigs)) {
            for (Mold.ProductMoldConfig config : productMoldConfigs) {
                ProductController.conditionCheck(StringUtils.isNotBlank((String)config.getSceneName()), "sceneName\u4e0d\u80fd\u4e3a\u7a7a");
                List productSceneConfigs = config.getProductSceneConfigs();
                if (!CollectionUtils.isNotEmpty((Collection)productSceneConfigs)) continue;
                for (Mold.ProductSceneConfig productSceneConfig : productSceneConfigs) {
                    ProductController.conditionCheck(StringUtils.isNotBlank((String)productSceneConfig.getDescription()), "description\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }

    @RequestMapping(value={"/product/findById"}, produces={"application/json"})
    public ResponseEntity<ProductVo> findById(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Integer id) {
        return ResponseEntity.ok((Object)this.productService.findById(id));
    }

    @RequestMapping(value={"/product/updateStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> updateStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.productService.updateStatus(id, status);
        return ResponseEntity.ok((Object)"true");
    }

    @GetMapping(value={"/product/updateLpKylinGroupId"})
    public ResponseEntity<String> updateLpKylinGroupId(@RequestParam Integer id, @RequestParam(required=false) String groupId) {
        this.productService.updateLpKylinGroupId(id, groupId);
        return ResponseEntity.ok((Object)"true");
    }

    @RequestMapping(value={"/product/batchUpdateStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> batchUpdateStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ids") String ids, @RequestParam(value="status") Integer status) {
        this.productService.batchUpdateStatus(ids, status);
        return ResponseEntity.ok((Object)"true");
    }

    @RequestMapping(value={"/product/findAll"}, produces={"application/json"})
    public ResponseEntity<List<ProductNameAndIdVo>> findAll(HttpServletRequest request, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.productService.findAll());
    }

    public static void conditionCheck(boolean expression, String errorMessage) {
        CheckUtil.conditionCheck((boolean)expression, (String)errorMessage);
    }
}

