/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.shopping.common.utils.DateUtil;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.shopping.service.impl.UserOrderServiceImpl;
import com.bxm.shopping.service.redis.RedisKeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schedule"})
public class ScheduleController {
    private static final Logger log = LoggerFactory.getLogger(ScheduleController.class);
    @Autowired
    private IUserOrderService userOrderService;
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    @Qualifier(value="jedisFetcherData")
    private JedisFetcher jedisFetcherData;

    @GetMapping(value={"/updateEmptyAdData"})
    public ResponseModel updateEmptyAdData() {
        Date startDate = DateUtil.increaseMinute((Date)new Date(), (int)-30);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.gt((Object)"create_time", (Object)startDate);
        List totalUserOrders = this.userOrderService.getBaseMapper().selectList((Wrapper)queryWrapper);
        List filterUserOrders = totalUserOrders.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getChannelOrderId()) && StringUtils.isBlank((CharSequence)u.getTicketId())).collect(Collectors.toList());
        log.info("\u66f4\u65b0\u7a7aticketId\u6570\u636e,\u5f85\u5904\u7406bxmid\u6761\u6570\uff1a{}", (Object)filterUserOrders.size());
        ArrayList<UserOrder> updateOrders = new ArrayList<UserOrder>();
        for (UserOrder userOrder : filterUserOrders) {
            String bxmId = userOrder.getChannelOrderId();
            UserOrder updateOrder = new UserOrder();
            updateOrder.setId(userOrder.getId());
            UserOrderServiceImpl.NewTicketInfo ticketInfoNew = (UserOrderServiceImpl.NewTicketInfo)this.jedisFetcherData.fetch(RedisKeyGenerator.getTicketInfoNew((String)bxmId), UserOrderServiceImpl.NewTicketInfo.class);
            if (Objects.nonNull(ticketInfoNew)) {
                if (CollectionUtils.isNotEmpty((Collection)ticketInfoNew.getAdid())) {
                    updateOrder.setTicketId((String)ticketInfoNew.getAdid().get(0));
                }
                if (CollectionUtils.isNotEmpty((Collection)ticketInfoNew.getTagid())) {
                    updateOrder.setPositionId((String)ticketInfoNew.getTagid().get(0));
                }
                if (!StringUtils.isNotBlank((CharSequence)updateOrder.getTicketId()) && !StringUtils.isNotBlank((CharSequence)updateOrder.getPositionId())) continue;
                updateOrders.add(updateOrder);
                continue;
            }
            String ticketInfo = (String)this.fetcher.fetch(RedisKeyGenerator.getTicketInfo((String)bxmId), String.class);
            if (StringUtils.isBlank((CharSequence)ticketInfo)) continue;
            String[] split = ticketInfo.split("\t");
            String appKey = split[4];
            String business = split[5];
            String ticketId = split[21];
            String businessId = business.split("-")[1];
            String positionId = appKey + "-" + businessId;
            updateOrder.setTicketId(ticketId);
            updateOrder.setPositionId(positionId);
            updateOrders.add(updateOrder);
        }
        if (CollectionUtils.isNotEmpty(updateOrders)) {
            this.userOrderService.updateBatchById(updateOrders);
        }
        return ResponseModelFactory.SUCCESS();
    }
}

