/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.acl.facade.model.ResultModel;
import com.bxm.shopping.dal.entity.Product;
import com.bxm.shopping.integration.acl.AclUserIntegration;
import com.bxm.shopping.service.IProductService;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/temp"})
public class TempController {
    private static final Logger log = LoggerFactory.getLogger(TempController.class);
    @Autowired
    IProductService productService;
    @Autowired
    AclUserIntegration aclUserIntegration;

    @GetMapping(value={"/fixAeData"})
    public ResponseModel transfer() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.isNotNull((Object)"ae");
        queryWrapper.ne((Object)"status", (Object)Product.STATUS_DELETED);
        List list = this.productService.list((Wrapper)queryWrapper);
        Map<String, String> idTypeCodeMap = this.getIdTypeCodeMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Product product : list) {
                if (StringUtils.isBlank((CharSequence)product.getAe())) continue;
                String typeCode = idTypeCodeMap.getOrDefault(product.getAe(), product.getAe());
                Product forInset = new Product();
                forInset.setId(product.getId());
                forInset.setAe(typeCode);
                boolean b = this.productService.updateById((Object)forInset);
                log.info("ae change to {}, success: {}", (Object)typeCode, (Object)b);
            }
        }
        return ResponseModelFactory.SUCCESS();
    }

    Map<String, String> getIdTypeCodeMap() {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange("https://mgr.bianxianmao.com:18501/common/findUsersByRoleCode?roleCode=ae", HttpMethod.GET, httpEntity, String.class, new Object[0]);
        ResultModel resultModel = (ResultModel)JsonHelper.convert((String)((String)exchange.getBody()), ResultModel.class);
        List resList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resultModel.getReturnValue()), Res.class);
        Map<String, String> idTypeCodeMap = resList.stream().collect(Collectors.toMap(r -> r.getId(), r -> r.getTypecode()));
        return idTypeCodeMap;
    }

    public static class Res {
        private String id;
        private String typecode;
        private String typename;

        public String getId() {
            return this.id;
        }

        public String getTypecode() {
            return this.typecode;
        }

        public String getTypename() {
            return this.typename;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setTypecode(String typecode) {
            this.typecode = typecode;
        }

        public void setTypename(String typename) {
            this.typename = typename;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$typecode = this.getTypecode();
            String other$typecode = other.getTypecode();
            if (this$typecode == null ? other$typecode != null : !this$typecode.equals(other$typecode)) {
                return false;
            }
            String this$typename = this.getTypename();
            String other$typename = other.getTypename();
            return !(this$typename == null ? other$typename != null : !this$typename.equals(other$typename));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $typecode = this.getTypecode();
            result = result * 59 + ($typecode == null ? 43 : $typecode.hashCode());
            String $typename = this.getTypename();
            result = result * 59 + ($typename == null ? 43 : $typename.hashCode());
            return result;
        }

        public String toString() {
            return "TempController.Res(id=" + this.getId() + ", typecode=" + this.getTypecode() + ", typename=" + this.getTypename() + ")";
        }
    }
}

