/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.global;

import com.bxm.shopping.common.exception.BusinessException;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public ResponseModel<String> unsupportedOperation() {
        return ResponseModelFactory.FAILED400();
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public ResponseModel<String> illegalStateException(Throwable throwable) {
        return ResponseModelFactory.FAILED400();
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ResponseModel<String> illegalArgument(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)HttpStatus.BAD_REQUEST.value(), (String)throwable.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseModel HttpRequestMethodNotSupportedException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)HttpStatus.BAD_REQUEST.value(), (String)throwable.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResponseModel missingServletRequestParameterException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)HttpStatus.BAD_REQUEST.value(), (String)throwable.getMessage());
    }

    @ExceptionHandler(value={ValidateException.class})
    @ResponseBody
    public ResponseModel ValidateException(Throwable throwable) {
        return ResponseModelFactory.FAILED((Integer)HttpStatus.BAD_REQUEST.value(), (String)throwable.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseModel<String> HttpMessageNotReadableException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED((Integer)400, (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u53c2\u6570");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseModel exception(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ResponseModel businessException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED500((String)throwable.getMessage());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseModel BindException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        String[] msg = throwable.getMessage().split(";");
        String finalmsg = msg[msg.length - 1].replace("default", "").replace("message", "").replace("[", "").replace("]", "").replace(" ", "");
        return ResponseModelFactory.FAILED((Integer)HttpStatus.BAD_REQUEST.value(), (String)finalmsg);
    }

    @ExceptionHandler(value={ShoppingException.class})
    @ResponseBody
    public ResponseModel handleGatherException(Exception e) {
        return ResponseModelFactory.FAILED500((String)e.getMessage());
    }
}

