package com.bxm.spider.deal.dal.mapper;

import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.News;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 爬取网页内容表(分表) Mapper 接口
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
@Repository
public interface NewsMapper extends MultiPageMapper<News> {
    /**
     * 根据动态表名插入数据
     * @date: 2018/10/18
     * @param news
     * @return int
     * @throws
     */
    int insertReturnId(News news);

    /**
     * 根据表名、url、最后更新时间获取新闻数据
     * @date: 2018/10/18
     * @param suffix 表名后缀
     * @param urlCode
     * @return java.util.List<com.bxm.spider.deal.model.dao.News>
     * @throws 
     */
    News findNewsByUrl(@Param("suffix") String suffix, @Param("urlCode") Integer urlCode);

    /**
     * 修改新闻
     * @date: 2018/10/24
     * @param news
     * @return int
     * @throws 
     */
    int updateNewsById(News news);

    /**
     * 根据url_code获取新闻
     * @date: 2018/12/3
     * @param suffix
     * @param urlCode
     * @return java.util.List<com.bxm.spider.deal.model.dao.News>
     * @throws 
     */
    List<News> selectByUrlCode(@Param("suffix") String suffix, @Param("urlCode") Integer urlCode);

    /**
     * 获取指定时间内的新闻数据
     * @date: 2018/12/17
     * @param modifyTime
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.String>>
     * @throws 
     */
    List<Map<String,String>> findNewsByModifyTime(@Param("modifyTime") Date modifyTime);

    /**
     * 根据 id 获取新闻信息
     * @date: 2018/12/17
     * @param id
     * @param suffix
     * @return java.util.Map<java.lang.String,java.lang.Object>
     * @throws 
     */
    Map<String,String> findNewsById(@Param("id") Long id, @Param("suffix") String suffix);

    /**
     * 根据条件查询列表
     * @date: 2018/12/20
     * @param contentDto
     * @return java.util.List<com.bxm.spider.deal.facade.model.ContentVo>
     * @throws 
     */
    List<ContentVo> listContent(ContentDto contentDto);

}
