package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.deal.model.dao.NewsContent;

/**
 * <p>
 * 爬取网页内容表(分表) 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public interface NewsContentService extends IService<NewsContent> {
    /**
     * 根据表名后缀，动态插入新闻内容表格
     * @date: 2018/10/18
     * @param url 下载的url
     * @param newsContent 新闻内容
     * @return int
     * @throws
     */
    int insert(String url, NewsContent newsContent);

    /**
     * 根据id 修改新闻内容
     * @date: 2018/10/24
     * @param url 下载的url
     * @param newsContent 新闻内容
     * @return int
     * @throws
     */
    int updateById(String url, NewsContent newsContent);
}
