package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.News;
import com.bxm.spider.deal.model.dao.NewsContent;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 爬取网页内容表(分表) 服务类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public interface NewsService extends IService<News> {
    /**
     * 根据表名后缀、url、最后更新时间获取新闻数据
     * @date: 2018/10/18
     * @param url 下载的url
     * @return java.util.List<com.bxm.spider.deal.model.dao.News>
     * @throws
     */
    News findNewsByUrl(String url);

    /**
     * 新增新闻
     * @date: 2018/10/18
     * @param news 新闻对象
     * @return int
     * @throws
     */
    int insertNews(News news);

    /**
     * 修改新闻
     * @date: 2018/10/24
     * @param news
     * @return int
     * @throws
     */
    int updateNewsById(News news);

    /**
     * 同时保存新闻和新闻内容
     * @date: 2018/10/19
     * @param news
     * @param newsContent
     * @return int
     * @throws
     */
    long insertNewsAndContent(News news, NewsContent newsContent, ProcessorParameter processorParameter);

    /**
     * 初始化15天内容新闻内容simHash到redis
     * @date: 2018/12/17
     * @param amount
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.String>>
     * @throws 
     */
    List<Map<String,String>> findNewsByModifyTime(int amount);

    /**
     * 根据id 获取新闻信息
     * @date: 2018/12/17
     * @param id
     * @param suffix
     * @return java.util.Map<java.lang.String,java.lang.Object>
     * @throws 
     */
    Map<String,String> findNewsById(Long id, String suffix);

    /**
     * 查询列表
     * @date: 2018/12/20
     * @param contentDto
     * @return java.util.List<com.bxm.spider.deal.facade.model.ContentVo>
     * @throws 
     */
    List<ContentVo> listContent(ContentDto contentDto);
}
