package com.bxm.spider.deal.dal.service;

import com.baomidou.mybatisplus.service.IService;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.deal.model.dao.NewsWechat;
import com.bxm.spider.deal.model.dao.NewsWechatContent;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 微信爬取网页内容表 服务类
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-30
 */
public interface NewsWeChatService extends IService<NewsWechat> {
    /**
     * 根据微信的公众号与标题查询数据的唯一性
     *
     * @param wechatPm
     * @param title
     * @return com.bxm.spider.deal.model.dao.NewsWechat
     * @throws
     * @author kk.xie
     * @date 2018/10/30 17:34
     */
    NewsWechat findByPmTitle(String wechatPm, String title);

    /**
     * 新增
     *
     * @param newsWechat
     * @return int
     * @throws
     * @author kk.xie
     * @date 2018/10/30 17:33
     */
    boolean insertWechat(NewsWechat newsWechat);

    /**
     * 修改
     *
     * @param newsWechat
     * @return int
     * @throws
     * @author kk.xie
     * @date 2018/10/30 17:33
     */
    boolean updateWechatById(NewsWechat newsWechat);

    /**
     * 同时保存微信新闻和新闻内容
     *
     * @param newsWechat
     * @param newsWechatContent
     * @return int
     * @throws
     * @author kk.xie
     * @date 2018/10/30 17:33
     */
    boolean insertNewsAndContent(NewsWechat newsWechat, NewsWechatContent newsWechatContent, ProcessorParameter processorParameter);

    /**
     * 初始化微信新闻前15天的内容simHash到
     * @date: 2018/12/17
     * @param amount 天数
     * @return java.lang.Integer
     * @throws redis
     */
    List<Map<String,String>> findNewsByModifyTime(int amount);

    /**
     * 根据id获取新闻信息，包括 title和
     * @date: 2018/12/17
     * @param id
     * @return java.util.Map<java.lang.String,java.lang.String>
     * @throws 
     */
    Map<String,String> findNewsById(Long id);

    List<ContentVo> findList(ContentDto contentDto);
}
