package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.common.utils.StringHelp;
import com.bxm.spider.deal.dal.mapper.NewsContentMapper;
import com.bxm.spider.deal.dal.service.NewsContentService;
import com.bxm.spider.deal.model.dao.NewsContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 爬取网页内容表(分表) 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
@Service
public class NewsContentServiceImpl extends ServiceImpl<NewsContentMapper, NewsContent> implements NewsContentService {
    @Autowired
    private NewsContentMapper contentMapper;

    @Override
    public int insert(String url, NewsContent newsContent) {
        newsContent.setSuffix(StringHelp.getHashCodeModTen(url));
        return contentMapper.insertContent(newsContent);
    }

    @Override
    public int updateById(String url,NewsContent newsContent) {
        newsContent.setSuffix(StringHelp.getHashCodeModTen(url));
        return contentMapper.updateContentById(newsContent);
    }
}
