package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.UrlConfigMapper;
import com.bxm.spider.deal.dal.service.UrlConfigService;
import com.bxm.spider.deal.model.dao.UrlConfig;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 前端配置表 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
@Service("dealUrlConfigService")
public class UrlConfigServiceImpl extends ServiceImpl<UrlConfigMapper, UrlConfig> implements UrlConfigService {

    @Override
    public UrlConfig getConfigBySerialNum(String serialNum,String originUrl) {
        Wrapper<UrlConfig> wrapper = new EntityWrapper<UrlConfig>();
        wrapper.eq("serial_num",serialNum);
        wrapper.eq("url",originUrl);
        wrapper.eq("status",1);
        return this.selectOne(wrapper);
    }
}
