package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.common.utils.StringHelp;
import com.bxm.spider.deal.dal.mapper.WechatNewsContentMapper;
import com.bxm.spider.deal.dal.service.WechatNewsContentDbService;
import com.bxm.spider.deal.model.dao.WechatNewsContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 爬取网页内容表(分表) 服务实现类
 * </p>
 *
 * @author stephen
 * @since 2019-01-03
 */
@Service
public class WechatNewsContentDbServiceImpl extends ServiceImpl<WechatNewsContentMapper, WechatNewsContent> implements WechatNewsContentDbService {

    @Autowired
    private WechatNewsContentMapper contentMapper;

    @Override
    public int insert(String url, WechatNewsContent newsContent) {
        newsContent.setSuffix(StringHelp.getHashCodeModTen(url));
        return contentMapper.insertContent(newsContent);
    }

    @Override
    public int updateById(String url, WechatNewsContent newsContent) {
        newsContent.setSuffix(StringHelp.getHashCodeModTen(url));
        return contentMapper.updateContentById(newsContent);
    }
}
