package com.bxm.spider.deal.dal.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.deal.dal.mapper.WorkMapper;
import com.bxm.spider.deal.dal.service.WorkService;
import com.bxm.spider.deal.model.dao.Work;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 招聘职位表 服务实现类
 * </p>
 *
 * @author JandMin
 * @since 2018-11-20
 */
@Service
public class WorkServiceImpl extends ServiceImpl<WorkMapper, Work> implements WorkService {

    @Override
    public List<Work> selectByModifyTime(Long times) {
        Wrapper<Work> wrapper = new EntityWrapper<Work>();
        Date now = new Date();
        if(null == times) {
            times = 86400000L;//一天
        }
        Date beforeDate = new Date(now.getTime() - times.longValue());
        wrapper.ge("modify_time", beforeDate);
        wrapper.and().eq("status", 1);
        return this.selectList(wrapper);
    }

    @Override
    public Work selectByUrl(String url) {
        Wrapper<Work> wrapper = new EntityWrapper<Work>();
        wrapper.eq("url_code",url.hashCode());
        return this.selectOne(wrapper);
    }
}
