package com.bxm.spider.deal.dal.utils;

import com.bxm.spider.deal.dal.mapper.MultiPageMapper;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.multipage.MultiPageParam;
import com.bxm.spider.multipage.MultiPageUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * <p> 多表查询工具类 </p>
 *
 * @Author: stephen
 * @since: 1.1.2
 * @Date: 2019/01/07
 */
public class MultiPageHelps {

    /**
     * 根据条件多表查询数据
     *
     * @param contentDto
     * @param mapper
     * @return
     */
    public static Page<ContentVo> list(ContentDto contentDto, MultiPageMapper mapper) {
        PageHelper.clearPage();
        int[] countArr = new int[10];
        int total = 0;

        for (Integer i = 0; i < 10; i++) {
            contentDto.setSuffix(i.toString());
            countArr[i] = mapper.getCountBySuffix(contentDto);
            total += countArr[i];
        }

        Page<ContentVo> resultList = new Page<>();
        resultList.setPageNum(contentDto.getCurrentPage());
        resultList.setPageSize(contentDto.getPageSize());
        resultList.setTotal(total);

        List<MultiPageParam> conditions = MultiPageUtils.calPage(contentDto.getCurrentPage(), contentDto.getPageSize(), countArr);
        if (CollectionUtils.isNotEmpty(conditions)) {
            for (MultiPageParam condition : conditions) {
                contentDto.setSuffix(condition.getSuffix());
                contentDto.setCurrent(condition.getCurrent());
                contentDto.setSize(condition.getSize());
                resultList.addAll(mapper.getListBySuffix(contentDto));
            }
        }

        return resultList;
    }

}
