package com.bxm.spider.manager.service;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

/**
 * 爬虫运营后台服务
 *
 * @author kk.xie
 * @date 2018/10/18 14:23
 */  
@MapperScan("com.bxm.spider.manager.dal.mapper")
@ComponentScan("com.bxm.spider")
@EnableFeignClients({"com.bxm.spider.prod.facade","com.bxm.spider.deal.facade", "com.bxm.spider.monitor.facade"})
@SpringBootApplication
@EnableDiscoveryClient
public class SpiderManagerApplication {
	public static void main(String[] args) {
		SpringApplication.run(SpiderManagerApplication.class, args);
	}
}
