package com.bxm.spider.manager.service;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * swagger启动
 *
 * @ClassName SpiderManagerSwaggerApplication
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/19 14:53
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/19 14:53
 **/
@Configuration
@EnableSwagger2
@Profile({"dev","test"})
public class SpiderManagerSwaggerApplication {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.bxm.spider.manager.service.controller"))
                .paths(PathSelectors.any())
                .build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("Manager-Service RESTful APIs")
                .termsOfServiceUrl("www.bianxianmao.com")
                .contact(new Contact("kk.xie","www.bianxianmao.com","xiewei@bianxianmao.com"))
                .version("1.0")
                .build();
    }
}
