package com.bxm.spider.manager.service.config;

import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.plugins.PerformanceInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

/**
 * mybatis-plus config
 *
 * @ClassName MybatisPlusConfig
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/8/28 11:59
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/8/28 11:59
 **/
@Configuration
public class MybatisPlusConfig {


    /**
     * 分页插件
     * 设置 dev test 环境开启
     *
     * @param
     * @return com.baomidou.mybatisplus.plugins.PaginationInterceptor
     * @throws
     * @author kk.xie
     * @date 2018/8/28 12:01
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }


    /**
     * 性能分析拦截器
     *
     * @param
     * @return com.baomidou.mybatisplus.plugins.PerformanceInterceptor
     * @throws
     * @author kk.xie
     * @date 2018/8/28 12:03
     */
    @Bean
    @Profile({"dev","test"})
    public PerformanceInterceptor performanceInterceptor(){
        return new PerformanceInterceptor();
    }
}
