package com.bxm.spider.manager.service.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * mvc配置
 *
 * @ClassName CorsConfig
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/25 15:04
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/25 15:04
 **/
@Configuration
public class WebMvcConfig extends WebMvcConfigurerAdapter {
    /**
     * 跨域配置
     *
     * @param registry
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/7/30 9:47
     */
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        //设置允许跨域的路径
        registry.addMapping("/**")
                //设置允许跨域请求的域名
                .allowedOrigins("*")
                //是否允许证书 不再默认开启
                .allowCredentials(true)
                //设置允许的方法
                .allowedMethods("*")
                //跨域允许时间
                .maxAge(3600);
    }
}
