package com.bxm.spider.manager.service.controller;

import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.manager.model.dto.ContentUpdateDto;
import com.bxm.spider.manager.service.service.ContentService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>  内容管理控制层 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
@Api(tags = "内容管理")
@RestController
@RequestMapping("/content")
public class ContentController {
    @Autowired
    private ContentService contentService;

    @ApiOperation(value="状态修改")
    @RequestMapping(value = "/update/status", method = RequestMethod.POST)
    public ResponseModel<Integer> updateStatus(@RequestBody ContentUpdateDto updateDto){
        return contentService.updateStatus(updateDto);
    }

    @ApiOperation(value="分页查询内容")
    @RequestMapping(value = "/list/page", method = RequestMethod.POST)
    public ResponseModel<PageInfo<ContentVo>> listContentByPage(@RequestBody ContentDto contentDto){
        return contentService.listContentByPage(contentDto);
    }
}
