package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.SpiderException;
import com.bxm.spider.manager.model.dto.SpiderExceptionDto;
import com.bxm.spider.manager.service.service.SpiderExceptionService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 异常信息控制器
 *
 * @ClassName ExceptionController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/11/27 10:55
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/11/27 10:55
 **/
@Api(tags = "报表-异常报表")
@RestController
@RequestMapping("/exception")
public class ExceptionController {

    @Autowired
    private SpiderExceptionService spiderExceptionService;
    /**
     * 分页查询
     *
     * @param spiderExceptionDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<com.bxm.spider.manager.model.dao.SpiderException>>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 14:05
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<SpiderException>> selectPage(@ModelAttribute SpiderExceptionDto spiderExceptionDto){
        return ResponseModelFactory.SUCCESS(spiderExceptionService.selectPage(spiderExceptionDto));
    }

    /**
     * 查询
     *
     * @param spiderExceptionDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.bxm.spider.manager.model.dao.UrlTask>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 14:05
     */
    @ApiOperation(value="查询一条")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<SpiderException> selectById(@ModelAttribute SpiderExceptionDto spiderExceptionDto){
        return ResponseModelFactory.SUCCESS(spiderExceptionService.selectById(spiderExceptionDto.getId()));
    }
}
