package com.bxm.spider.manager.service.controller;

import com.bxm.spider.monitor.facade.model.SpiderExceptionMonitorVo;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportDto;
import com.bxm.spider.monitor.facade.model.SpiderMonitorReportVo;
import com.bxm.spider.monitor.facade.service.MonitorReportFacadeService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 监控日志报表服务
 *
 * @ClassName MonitorReportController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 15:15
 * @Version 1.0
 **/
@Api(tags = "监控日志报表服务")
@RestController
@RequestMapping("/monitorReport")
public class MonitorReportController {

    @Autowired
    private MonitorReportFacadeService monitorReportService;

    @ApiOperation(value="分页查询站点列表")
    @RequestMapping(value = "/getSitePageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderMonitorReportVo>> getSitePageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        return monitorReportService.getSitePageList(spiderMonitorReportDto);
    }

    @ApiOperation(value="分页查询应用列表")
    @RequestMapping(value = "/getAppPageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderMonitorReportVo>> getAppPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        return monitorReportService.getAppPageList(spiderMonitorReportDto);
    }

    @ApiOperation(value="分页查询错误列表")
    @RequestMapping(value = "/getErrorPageList", method = RequestMethod.POST)
    public ResponseModel<PageInfo<SpiderExceptionMonitorVo>> getErrorPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        return monitorReportService.getErrorPageList(spiderMonitorReportDto);
    }

}
