package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.SpiderReport;
import com.bxm.spider.manager.model.dto.SpiderReportDto;
import com.bxm.spider.manager.service.service.SpiderReportService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 报表控制器
 *
 * @ClassName ReportController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/11/27 10:55
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/11/27 10:55
 **/
@Api(tags = "报表-统计报表")
@RestController
@RequestMapping("/report")
public class ReportController {
    @Autowired
    private SpiderReportService spiderReportService;

    /**
     * 新增
     *
     * @param spiderReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 11:10
     */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody SpiderReport spiderReport){
        return ResponseModelFactory.SUCCESS(spiderReportService.insert(spiderReport));
    }

    /**
     * 修改
     *
     * @param spiderReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 11:12
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody SpiderReport spiderReport) {
        return ResponseModelFactory.SUCCESS(spiderReportService.updateById(spiderReport));
    }

    /**
     * 删除
     *
     * @param spiderReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 11:13
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody SpiderReport spiderReport){
        return ResponseModelFactory.SUCCESS(spiderReportService.deleteById(spiderReport.getId()));
    }

    /**
     * 分页查询
     *
     * @param spiderReportDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<com.bxm.spider.manager.model.dao.SpiderReport>>
     * @throws
     * @author kk.xie
     * @date 2018/11/27 11:13
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<SpiderReport>> selectPage(@ModelAttribute SpiderReportDto spiderReportDto){
        return ResponseModelFactory.SUCCESS(spiderReportService.selectPage(spiderReportDto));
    }

    /**
     * 查询选择日期的小时报表
     *
     * @param spiderReportDto
     * @return com.bxm.warcar.utils.response.ResponseModel<spiderReport>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="查询选择日期的小时报表")
    @RequestMapping(value = "/selectHourReport", method = RequestMethod.GET)
    public ResponseModel<List<SpiderReport>> selectHourReport(@ModelAttribute SpiderReportDto spiderReportDto){
        return ResponseModelFactory.SUCCESS(spiderReportService.selectHourReport(spiderReportDto));
    }
}
