package com.bxm.spider.manager.service.controller;

import com.bxm.spider.manager.integration.prod.model.TaskDto;
import com.bxm.spider.manager.service.service.SpiderExecuteService;
import com.bxm.warcar.utils.response.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 爬虫总控制器
 *
 * @ClassName controller
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/17 17:23
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/17 17:23
 **/
@Api(tags = "执行任务开关")
@RestController
@RequestMapping("/spider")
public class SpiderController {

    @Autowired
    private SpiderExecuteService spiderExecuteService;

    /**
     * 启动爬取
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 18:17
     */
    @ApiOperation(value="启动爬取")
    @RequestMapping(value = "/start", method = RequestMethod.POST)
    public ResponseModel<Boolean> start(@RequestBody TaskDto taskDto) {
        return spiderExecuteService.start(taskDto);
    }

    /**
     * 暂停爬取
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 18:17
     */
    @ApiOperation(value="暂停爬取")
    @RequestMapping(value = "/pause", method = RequestMethod.POST)
    public ResponseModel<Boolean> pause(@RequestBody  TaskDto taskDto) {
        return spiderExecuteService.pause(taskDto);
    }

    /**
     * 恢复爬取
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 18:17
     */
    @ApiOperation(value="恢复爬取")
    @RequestMapping(value = "/resume", method = RequestMethod.POST)
    public ResponseModel<Boolean> resume(@RequestBody TaskDto taskDto) {
        return spiderExecuteService.resume(taskDto);
    }

    /**
     * 停止爬取
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 18:17
     */
    @ApiOperation(value="停止爬取")
    @RequestMapping(value = "/stop", method = RequestMethod.POST)
    public ResponseModel<Boolean> stop(@RequestBody TaskDto taskDto) {
        return spiderExecuteService.stop(taskDto);
    }

    @ApiOperation(value="重启所有的任务")
    @RequestMapping(value = "/restartAll", method = RequestMethod.POST)
    public ResponseModel<Boolean> restartAll(){
        return spiderExecuteService.restartAll();
    }
}
