package com.bxm.spider.manager.service.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.SpiderWarnRate;
import com.bxm.spider.manager.model.dto.SpiderWarnRateDto;
import com.bxm.spider.manager.service.service.SpiderWarnRateService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p>
 * 告警比例配置表 前端控制器
 * </p>
 *
 * @author kk.xie
 * @since 2018-12-12
 */
@Api(tags = "告警比例配置表")
@Controller
@RequestMapping("/spiderWarnRate")
public class SpiderWarnRateController {

    @Autowired
    private SpiderWarnRateService spiderWarnRateService;

    /**
     * 新增
     *
     * @param spiderWarnRate
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody SpiderWarnRate spiderWarnRate){
        return ResponseModelFactory.SUCCESS(spiderWarnRateService.insert(spiderWarnRate));
    }

    /**
     * 修改
     *
     * @param spiderWarnRate
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody SpiderWarnRate spiderWarnRate) {
        return ResponseModelFactory.SUCCESS(spiderWarnRateService.updateById(spiderWarnRate));
    }

    /**
     * 删除
     *
     * @param spiderWarnRate
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody SpiderWarnRate spiderWarnRate){
        return ResponseModelFactory.SUCCESS(spiderWarnRateService.deleteById(spiderWarnRate.getId()));
    }

    /**
     * 分页查询
     *
     * @param spiderWarnRateDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<UrlTask>>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<SpiderWarnRate>> selectPage(@ModelAttribute SpiderWarnRateDto spiderWarnRateDto){
        return ResponseModelFactory.SUCCESS(spiderWarnRateService.selectPage(spiderWarnRateDto));
    }

    /**
     * 查询
     *
     * @param spiderWarnRateDto
     * @return com.bxm.warcar.utils.response.ResponseModel<UrlTask>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="查询一条")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<SpiderWarnRate> selectById(@ModelAttribute SpiderWarnRateDto spiderWarnRateDto){
        return ResponseModelFactory.SUCCESS(spiderWarnRateService.selectById(spiderWarnRateDto.getId()));
    }
}

