package com.bxm.spider.manager.service.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.SpiderWarnReport;
import com.bxm.spider.manager.model.dto.SpiderWarnReportDto;
import com.bxm.spider.manager.service.service.SpiderWarnReportService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p>
 * 告警比例报表 前端控制器
 * </p>
 *
 * @author kk.xie
 * @since 2018-12-12
 */
@Api(tags = "告警比例报表")
@Controller
@RequestMapping("/spiderWarnReport")
public class SpiderWarnReportController {

    @Autowired
    private SpiderWarnReportService spiderWarnReportService;

    /**
     * 新增
     *
     * @param spiderWarnReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody SpiderWarnReport spiderWarnReport){
        return ResponseModelFactory.SUCCESS(spiderWarnReportService.insert(spiderWarnReport));
    }

    /**
     * 修改
     *
     * @param spiderWarnReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody SpiderWarnReport spiderWarnReport) {
        return ResponseModelFactory.SUCCESS(spiderWarnReportService.updateById(spiderWarnReport));
    }

    /**
     * 删除
     *
     * @param spiderWarnReport
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody SpiderWarnReport spiderWarnReport){
        return ResponseModelFactory.SUCCESS(spiderWarnReportService.deleteById(spiderWarnReport.getId()));
    }

    /**
     * 分页查询
     *
     * @param spiderWarnReportDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<UrlTask>>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<SpiderWarnReport>> selectPage(@ModelAttribute SpiderWarnReportDto spiderWarnReportDto){
        return ResponseModelFactory.SUCCESS(spiderWarnReportService.selectPage(spiderWarnReportDto));
    }

    /**
     * 查询
     *
     * @param spiderWarnReportDto
     * @return com.bxm.warcar.utils.response.ResponseModel<UrlTask>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="查询一条")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<SpiderWarnReport> selectById(@ModelAttribute SpiderWarnReportDto spiderWarnReportDto){
        return ResponseModelFactory.SUCCESS(spiderWarnReportService.selectById(spiderWarnReportDto.getId()));
    }
}

