package com.bxm.spider.manager.service.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.UrlConfig;
import com.bxm.spider.manager.model.dto.UrlConfigDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * <p>
 * 前端配置表 前端控制器
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Api(tags = "调度任务-url配置")
@RestController
@RequestMapping("/config")
public class UrlConfigController {

    @Autowired
    private UrlConfigService urlConfigService;

   /**
    * 新增
    *
    * @param urlConfig
    * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
    * @throws
    * @author kk.xie
    * @date 2018/10/16 17:50
    */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody  UrlConfig urlConfig){
        return ResponseModelFactory.SUCCESS(urlConfigService.add(urlConfig));
    }

    /**
     * 修改
     *
     * @param urlConfig
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 17:51
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody  UrlConfig urlConfig){
        urlConfig.setModifyTime(new Date());
        return ResponseModelFactory.SUCCESS(urlConfigService.updateById(urlConfig));
    }

    /**
     * 删除
     *
     * @param urlConfig
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 17:51
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody  UrlConfig urlConfig){
        return  ResponseModelFactory.SUCCESS(urlConfigService.deleteById(urlConfig.getId()));
    }

    /**
     * 分页查询
     *
     * @param urlConfigDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<UrlConfig>>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 17:48
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<UrlConfig>> selectPage(@ModelAttribute UrlConfigDto urlConfigDto){
        return ResponseModelFactory.SUCCESS(urlConfigService.selectPage(urlConfigDto));
    }

   /**
    * 查询
    *
    * @param urlConfigDto
    * @return java.lang.String
    * @throws
    * @author kk.xie
    * @date 2018/10/16 17:51
    */
    @ApiOperation(value="查询一条")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<UrlConfig> selectById(@ModelAttribute UrlConfigDto urlConfigDto){
        return ResponseModelFactory.SUCCESS(urlConfigService.selectById(urlConfigDto.getId()));
    }
}

