package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.UrlConfig;
import com.bxm.spider.manager.model.dao.UrlRuler;
import com.bxm.spider.manager.model.dto.UrlRulerDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import com.bxm.spider.manager.service.service.UrlRulerService;
import com.bxm.warcar.utils.HttpUtils;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 过滤规则表 前端控制器
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Api(tags = "调度任务-规则配置")
@RestController
@RequestMapping("/ruler")
public class UrlRulerController {

    private Logger logger = LoggerFactory.getLogger(UrlRulerController.class);

    @Autowired
    private UrlRulerService urlRulerService;

    @Autowired
    private UrlConfigService urlConfigService;
   /**
    * 新增
    *
    * @param urlRuler
    * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
    * @throws
    * @author kk.xie
    * @date 2018/10/16 20:09
    */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody UrlRuler urlRuler){
        urlRuler.setEscapeHtml( StringUtils.isEmpty(urlRuler.getEscapeHtml()) ? "0" : urlRuler.getEscapeHtml());
        return ResponseModelFactory.SUCCESS(urlRulerService.insert(urlRuler));
    }

    /**
     * 批量新增
     *
     * @param urlRulerList
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:47
     */
    @ApiOperation(value="批量新增")
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST)
    public ResponseModel<Boolean> addBatch(@RequestBody List<UrlRuler> urlRulerList){
        return ResponseModelFactory.SUCCESS(urlRulerService.insertBatch(urlRulerList));
    }

    /**
     * 修改
     *
     * @param urlRuler
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:10
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody UrlRuler urlRuler){
        urlRuler.setModifyTime(new Date());
        return ResponseModelFactory.SUCCESS(urlRulerService.updateById(urlRuler));
    }

    /**
     * 删除
     *
     * @param urlRuler
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:10
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody UrlRuler urlRuler){
        UrlRuler ruler = urlRulerService.selectById(urlRuler.getId());
        String site = ruler.getSite();
        List<UrlConfig> urlConfigList = urlConfigService.selectList(new EntityWrapper().eq("ruler_site", site));
        if(CollectionUtils.isNotEmpty(urlConfigList)){
            return ResponseModelFactory.FAILED(ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(),
                    "规则正在被使用，不允许删除!"
                    );
        }
        return ResponseModelFactory.SUCCESS(urlRulerService.deleteById(urlRuler.getId()));
    }

    /**
     * 分页查询
     *
     * @param urlRulerDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<UrlRuler>>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:09
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<UrlRuler>> selectPage(HttpServletRequest request, @ModelAttribute UrlRulerDto urlRulerDto){
        String ip = HttpUtils.getIpFromHeader(request);
        logger.info(ip);
        return ResponseModelFactory.SUCCESS(urlRulerService.selectPage(urlRulerDto));
    }

    /**
     * 查询
     *
     * @param urlRulerDto
     * @return com.bxm.warcar.utils.response.ResponseModel<UrlRuler>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:10
     */
    @ApiOperation(value="查询")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<UrlRuler> selectById(@ModelAttribute UrlRulerDto urlRulerDto){
        return ResponseModelFactory.SUCCESS(urlRulerService.selectById(urlRulerDto.getId()));
    }
}

