package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.constant.task.TaskStatusEnum;
import com.bxm.spider.manager.model.dao.UrlTask;
import com.bxm.spider.manager.model.dto.UrlTaskDto;
import com.bxm.spider.manager.service.service.UrlTaskService;
import com.bxm.spider.manager.service.util.PriderUtil;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * <p>
 * 任务表 前端控制器
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Api(tags = "调度任务-任务配置")
@RestController
@RequestMapping("/task")
public class UrlTaskController {

    @Autowired
    private UrlTaskService urlTaskService;

    /**
     * 新增
     *
     * @param urlTask
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="新增")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseModel<Boolean> add(@RequestBody UrlTask urlTask){
        String serialNum = PriderUtil.getSerialNum();
        urlTask.setSerialNum(serialNum);
        return ResponseModelFactory.SUCCESS(urlTaskService.insert(urlTask));
    }

    /**
     * 修改
     *
     * @param urlTask
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseModel<Boolean> update(@RequestBody UrlTask urlTask) {
        urlTask.setModifyTime(new Date());
        UrlTask task = urlTaskService.selectById(urlTask.getId());
        int executeStatus = task.getExecuteStatus().intValue();
        if (TaskStatusEnum.RUNNING.getCode() == executeStatus || TaskStatusEnum.PAUSE.getCode() == executeStatus) {
            return ResponseModelFactory.FAILED(
                    ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(),
                    "仅能修改 " + TaskStatusEnum.WAIT_START.getName() + " 与 " + TaskStatusEnum.STOP.getName() + " 状态的任务");
        }
        return ResponseModelFactory.SUCCESS(urlTaskService.updateById(urlTask));
    }

    /**
     * 删除
     *
     * @param urlTask
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResponseModel<Boolean> delete(@RequestBody UrlTask urlTask){
        UrlTask task = urlTaskService.selectById(urlTask.getId());
        int executeStatus = task.getExecuteStatus().intValue();
        if (TaskStatusEnum.RUNNING.getCode() == executeStatus || TaskStatusEnum.PAUSE.getCode() == executeStatus) {
            return ResponseModelFactory.FAILED(
                    ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(),
                    "仅能删除 " + TaskStatusEnum.WAIT_START.getName() + " 与 " + TaskStatusEnum.STOP.getName() + " 状态的任务");
        }
        return ResponseModelFactory.SUCCESS(urlTaskService.deleteById(urlTask.getId()));
    }

    /**
     * 分页查询
     *
     * @param urlTaskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<com.baomidou.mybatisplus.plugins.Page<UrlTask>>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="分页查询")
    @RequestMapping(value = "/selectPage", method = RequestMethod.GET)
    public ResponseModel<Page<UrlTask>> selectPage(@ModelAttribute UrlTaskDto urlTaskDto){
        return ResponseModelFactory.SUCCESS(urlTaskService.selectPage(urlTaskDto));
    }

    /**
     * 查询
     *
     * @param urlTaskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<UrlTask>
     * @throws
     * @author kk.xie
     * @date 2018/10/16 20:14
     */
    @ApiOperation(value="查询一条")
    @RequestMapping(value = "/selectById", method = RequestMethod.GET)
    public ResponseModel<UrlTask> selectById(@ModelAttribute UrlTaskDto urlTaskDto){
        return ResponseModelFactory.SUCCESS(urlTaskService.selectById(urlTaskDto.getId()));
    }
}

