package com.bxm.spider.manager.service.service;

import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.manager.model.dto.ContentUpdateDto;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;

/**
 * <p> 内容管理服务 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
public interface ContentService {

    /**
     * 修改内容状态
     * @date: 2018/12/20
     * @param updateDto
     * @return java.lang.Integer
     * @throws 
     */
    ResponseModel<Integer> updateStatus(ContentUpdateDto updateDto);

    /**
     * 分页查询内容
     * @date: 2018/12/20
     * @param contentDto
     * @return com.github.pagehelper.PageInfo<com.bxm.spider.deal.facade.model.ContentVo>
     * @throws
     */
    ResponseModel<PageInfo<ContentVo>> listContentByPage(ContentDto contentDto);
}
