package com.bxm.spider.manager.service.service;

import com.bxm.spider.manager.integration.prod.model.TaskDto;
import com.bxm.warcar.utils.response.ResponseModel;

/**
 * 爬虫执行任务服务
 *
 * @ClassName SpiderExecuteService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 17:09
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 17:09
 **/
public interface SpiderExecuteService {
    /**
     * 启动任务
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean> start(TaskDto taskDto);

    /**
     * 暂停任务
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean>pause(TaskDto taskDto);

    /**
     * 更新任务
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean>resume(TaskDto taskDto);

    /**
     * 停止任务
     *
     * @param taskDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/10/18 11:06
     */
    ResponseModel<Boolean>stop(TaskDto taskDto);

    /**
     * 重启所有任务
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/10 17:09
     */
    ResponseModel<Boolean>restartAll();
}
