package com.bxm.spider.manager.service.service.impl;

import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.deal.facade.model.ContentDto;
import com.bxm.spider.deal.facade.model.ContentVo;
import com.bxm.spider.manager.integration.prod.service.ContentDealIntegrationService;
import com.bxm.spider.manager.model.dto.ContentUpdateDto;
import com.bxm.spider.manager.service.service.ContentService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p> 内容管理服务实现 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/12/20
 */
@Service
public class ContentServiceImpl implements ContentService{
    @Autowired
    private ContentDealIntegrationService contenIntegration;

    @Override
    public ResponseModel<Integer> updateStatus(ContentUpdateDto updateDto) {
        if(null == updateDto){
            throw new BaseRunException("【修改状态】参数为空");
        }
        if(StringUtils.isBlank(updateDto.getPersistenceEnum())){
            throw new BaseRunException("【修改状态】存储器枚举为空");
        }
        if(null == updateDto.getStatus() || 3 < updateDto.getStatus().intValue()){
            throw new BaseRunException("【修改状态】状态有误");
        }
        if(null == updateDto.getIds() || updateDto.getIds().length == 0){
            throw new BaseRunException("【修改状态】新闻id为空");
        }
        return contenIntegration.updateStatus(updateDto.getPersistenceEnum(),updateDto.getStatus(),updateDto.getIds());
    }

    @Override
    public ResponseModel<PageInfo<ContentVo>> listContentByPage(ContentDto contentDto) {
        if(null == contentDto){
            throw new BaseRunException("【查询内容】参数为空");
        }
        if(StringUtils.isBlank(contentDto.getPersistenceEnum())){
            throw new BaseRunException("【查询内容】存储器为空");
        }
        return contenIntegration.listContent(contentDto);
    }
}
