package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.SpiderExceptionMapper;
import com.bxm.spider.manager.model.dao.SpiderException;
import com.bxm.spider.manager.model.dto.SpiderExceptionDto;
import com.bxm.spider.manager.service.service.SpiderExceptionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-11-27
 */
@Service
public class SpiderExceptionServiceImpl extends ServiceImpl<SpiderExceptionMapper, SpiderException> implements SpiderExceptionService {

    @Override
    public Page<SpiderException> selectPage(SpiderExceptionDto spiderExceptionDto) {
        Page<SpiderException> page = new Page();
        page.setCurrent(spiderExceptionDto.getPageNum());
        page.setSize(spiderExceptionDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);
        if(StringUtils.isNotBlank(spiderExceptionDto.getSerialNum())){
            entityWrapper.eq("serial_num", spiderExceptionDto.getSerialNum());
        }

        return super.selectPage(page, entityWrapper);
    }
}
