package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.constant.task.TaskStatusEnum;
import com.bxm.spider.manager.integration.prod.model.TaskDto;
import com.bxm.spider.manager.integration.prod.service.TaskFeignIntegrationService;
import com.bxm.spider.manager.model.dao.UrlTask;
import com.bxm.spider.manager.service.service.SpiderExecuteService;
import com.bxm.spider.manager.service.service.UrlTaskService;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 爬虫执行任务服务实现
 *
 * @ClassName SpiderExecuteServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 17:09
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 17:09
 **/
@Service
public class SpiderExecuteServiceImpl implements SpiderExecuteService {

    @Autowired
    private TaskFeignIntegrationService taskFeignIntegrationService;

    @Autowired
    private UrlTaskService urlTaskService;

    @Override
    public ResponseModel<Boolean> start(TaskDto taskDto) {
        ResponseModel<Boolean> responseModel = taskFeignIntegrationService.start(taskDto);
        if(responseModel.getData()){
            updateTaskStatus(TaskStatusEnum.RUNNING.getCode(),  taskDto.getSerialNum());
        }
        return responseModel;
    }

    @Override
    public ResponseModel<Boolean> pause(TaskDto taskDto) {
        ResponseModel<Boolean> responseModel = taskFeignIntegrationService.pause(taskDto);
        if(responseModel.getData()){
            updateTaskStatus(TaskStatusEnum.PAUSE.getCode(),  taskDto.getSerialNum());
        }
        return responseModel;
    }

    @Override
    public ResponseModel<Boolean> resume(TaskDto taskDto) {
        ResponseModel<Boolean> responseModel = taskFeignIntegrationService.resume(taskDto);
        if(responseModel.getData()){
            updateTaskStatus(TaskStatusEnum.RUNNING.getCode(),  taskDto.getSerialNum());
        }
        return responseModel;
    }

    @Override
    public ResponseModel<Boolean> stop(TaskDto taskDto) {
        ResponseModel<Boolean> responseModel = taskFeignIntegrationService.stop(taskDto);
        if(responseModel.getData()){
            updateTaskStatus(TaskStatusEnum.STOP.getCode(),  taskDto.getSerialNum());
        }
        return responseModel;
    }

    @Override
    public ResponseModel<Boolean> restartAll() {
        return taskFeignIntegrationService.restartAll();
    }

    private boolean updateTaskStatus(Integer status, String serialNum){
        UrlTask urlTask = new UrlTask();
        urlTask.setExecuteStatus(status);
        return urlTaskService.update(urlTask, new EntityWrapper().eq("serial_num", serialNum));
    }
}
