package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.SpiderReportMapper;
import com.bxm.spider.manager.model.dao.SpiderReport;
import com.bxm.spider.manager.model.dto.SpiderReportDto;
import com.bxm.spider.manager.service.service.SpiderReportService;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-11-27
 */
@Service
public class SpiderReportServiceImpl extends ServiceImpl<SpiderReportMapper, SpiderReport> implements SpiderReportService {

    @Override
    public Page<SpiderReport> selectPage(SpiderReportDto spiderReportDto) {
        Page<SpiderReport> page = new Page();
        page.setCurrent(spiderReportDto.getPageNum());
        page.setSize(spiderReportDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.setSqlSelect("serial_num as serialNum,date,sum(prod_down_success) as prodDownSuccess," +
                "sum(prod_down_fail) prodDownFail,sum(down_success) downSuccess,sum(down_fail) downFail," +
                "sum(down_deal_success) downDealSuccess,sum(down_deal_fail) downDealFail,sum(deal_prod_success) dealProdSuccess," +
                "sum(deal_prod_fail) dealProdFail,sum(deal_list_success) dealListSuccess,sum(deal_list_fail) dealListFail," +
                "sum(deal_details_success) dealDetailsSuccess,sum(deal_details_fail) dealDetailsFail," +
                "sum(deal_save_success) dealSaveSuccess,sum(deal_save_fail) dealSaveFail");
        entityWrapper.orderBy("date", false);
        entityWrapper.groupBy("date, serial_num");
        // 流水号
        if(StringUtils.isNotBlank(spiderReportDto.getSerialNum())){
            entityWrapper.eq("serial_num", spiderReportDto.getSerialNum());
        }else{
            entityWrapper.isNotNull("serial_num");
        }
        // 时间
        if(spiderReportDto.getDate() != null){
            String date = DateHelper.convertDateToString(spiderReportDto.getDate(), DateHelper.PATTERN_STR10);
            entityWrapper.eq("date", date);
        }

        return super.selectPage(page, entityWrapper);
    }

    @Override
    public List<SpiderReport> selectHourReport(SpiderReportDto spiderReportDto) {
        List<SpiderReport> reports = Lists.newArrayList();
        EntityWrapper entityWrapper = new EntityWrapper();
        // 流水号
        if(StringUtils.isNotBlank(spiderReportDto.getSerialNum())){
            entityWrapper.eq("serial_num", spiderReportDto.getSerialNum());
        }else{
            return reports;
        }
        // 时间
        if(spiderReportDto.getDate() != null){
            String date = DateHelper.convertDateToString(spiderReportDto.getDate(), DateHelper.PATTERN_STR10);
            entityWrapper.eq("date", date);
        }else{
            return reports;
        }

        reports = super.selectList(entityWrapper);
        return reports;
    }
}
