package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.SpiderWarnRateMapper;
import com.bxm.spider.manager.model.dao.SpiderWarnRate;
import com.bxm.spider.manager.model.dto.SpiderWarnRateDto;
import com.bxm.spider.manager.service.service.SpiderWarnRateService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 告警比例配置表 服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-12-12
 */
@Service
public class SpiderWarnRateServiceImpl extends ServiceImpl<SpiderWarnRateMapper, SpiderWarnRate> implements SpiderWarnRateService {

    @Override
    public Page<SpiderWarnRate> selectPage(SpiderWarnRateDto spiderWarnRateDto) {
        Page<SpiderWarnRate> page = new Page();
        page.setCurrent(spiderWarnRateDto.getPageNum());
        page.setSize(spiderWarnRateDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);
        if(StringUtils.isNotBlank(spiderWarnRateDto.getSerialNum())){
            entityWrapper.eq("serial_num", spiderWarnRateDto.getSerialNum());
        }

        return super.selectPage(page, entityWrapper);
    }
}
