package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.SpiderWarnReportMapper;
import com.bxm.spider.manager.model.dao.SpiderWarnReport;
import com.bxm.spider.manager.model.dto.SpiderWarnReportDto;
import com.bxm.spider.manager.service.service.SpiderWarnReportService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 告警比例报表 服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-12-12
 */
@Service
public class SpiderWarnReportServiceImpl extends ServiceImpl<SpiderWarnReportMapper, SpiderWarnReport> implements SpiderWarnReportService {

    @Override
    public Page<SpiderWarnReport> selectPage(SpiderWarnReportDto spiderWarnReportDto) {
        Page<SpiderWarnReport> page = new Page();
        page.setCurrent(spiderWarnReportDto.getPageNum());
        page.setSize(spiderWarnReportDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);
        if(StringUtils.isNotBlank(spiderWarnReportDto.getSerialNum())){
            entityWrapper.eq("serial_num", spiderWarnReportDto.getSerialNum());
        }

        return super.selectPage(page, entityWrapper);
    }
}
