package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.UrlConfigMapper;
import com.bxm.spider.manager.model.dao.UrlConfig;
import com.bxm.spider.manager.model.dao.UrlRuler;
import com.bxm.spider.manager.model.dto.UrlConfigDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 前端配置表 服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Service
public class UrlConfigServiceImpl extends ServiceImpl<UrlConfigMapper, UrlConfig> implements UrlConfigService {

    @Override
    public Page<UrlConfig> selectPage(UrlConfigDto urlConfigDto) {
        Page<UrlConfig> page = new Page();
        page.setCurrent(urlConfigDto.getPageNum());
        page.setSize(urlConfigDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);

        if(StringUtils.isNotEmpty(urlConfigDto.getRulerSite())){
            entityWrapper.like("ruler_site", urlConfigDto.getRulerSite());
        }
        if(StringUtils.isNotEmpty(urlConfigDto.getSerialNum())){
            entityWrapper.like("serial_num", urlConfigDto.getSerialNum());
        }
        if(StringUtils.isNotEmpty(urlConfigDto.getUrl())){
            entityWrapper.like("url", urlConfigDto.getUrl());
        }
        return super.selectPage(page, entityWrapper);
    }

    @Transactional(rollbackFor = Exception.class, timeout = 10000)
    @Override
    public boolean add(UrlConfig urlConfig) {
        super.insert(urlConfig);

        if(urlConfig.getPersistenceType() != null){

        }
        return true;
    }
}
