package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.UrlRulerMapper;
import com.bxm.spider.manager.model.dao.UrlConfig;
import com.bxm.spider.manager.model.dao.UrlRuler;
import com.bxm.spider.manager.model.dto.UrlRulerDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import com.bxm.spider.manager.service.service.UrlRulerService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 过滤规则表 服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Service
public class UrlRulerServiceImpl extends ServiceImpl<UrlRulerMapper, UrlRuler> implements UrlRulerService {

    @Autowired
    private UrlConfigService urlConfigService;

    @Autowired
    private UrlRulerService urlRulerService;

    @Override
    public Page<UrlRuler> selectPage(UrlRulerDto urlRulerDto) {
        Page<UrlRuler> page = new Page();
        page.setCurrent(urlRulerDto.getPageNum());
        page.setSize(urlRulerDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);

        if(StringUtils.isNotEmpty(urlRulerDto.getName())){
            entityWrapper.like("name", urlRulerDto.getName());
        }
        if(StringUtils.isNotEmpty(urlRulerDto.getSite())){
            entityWrapper.like("site", urlRulerDto.getSite());
        }
        if(urlRulerDto.getPageNum() != null){
            List<UrlRuler> resultRuler = Lists.newArrayList();
            String serialNum = urlRulerDto.getSerialNum();
            List<UrlConfig> list = urlConfigService.selectList(new EntityWrapper().eq("serial_num", serialNum));
            if(CollectionUtils.isNotEmpty(list)){
                // 获取配置的所有url config site
                List<String> rulerList = Lists.newArrayList();
                for(UrlConfig urlConfig : list){
                    String rulerSite = urlConfig.getRulerSite();
                    if(!rulerList.contains(rulerSite)){
                        rulerList.add(rulerSite);
                    }
                }

                List<UrlRuler> urlRulerList = urlRulerService.selectList(new EntityWrapper().in("site", rulerList));
                if(CollectionUtils.isNotEmpty(urlRulerList)){
                    // 查询父规则
                    List<String> parentSiteList = Lists.newArrayList();
                    for(UrlRuler urlRuler : urlRulerList){
                        String parentSite = urlRuler.getParentSite();
                        if(parentSite != null && !parentSiteList.contains(parentSite)){
                            parentSiteList.add(parentSite);
                        }
                    }
                    if(CollectionUtils.isNotEmpty(parentSiteList)){
                        List<UrlRuler> urlRulerParentList  = urlRulerService.selectList(new EntityWrapper().in("site", parentSiteList));
                        // 添加父规则
                        resultRuler.addAll(urlRulerParentList);
                    }

                    Map<String, UrlRuler> siteMap = Maps.newHashMap();
                    urlRulerList.forEach(urlRuler -> siteMap.put(urlRuler.getKeyword(), urlRuler));

                   for(int i= 0; i< resultRuler.size(); i++){
                       UrlRuler urlRuler = resultRuler.get(i);
                       String keyword = urlRuler.getKeyword();
                       // 子规则中包含父规则字段，使用子规则字段
                       if(siteMap.containsKey(keyword)){
                           // 移除相同的
                           resultRuler.remove(urlRuler);
                       }
                   }
                   // 添加子规则，父规则相同的已经移除
                    resultRuler.addAll(urlRulerList);
                }
            }
            if(CollectionUtils.isNotEmpty(resultRuler)){
                List<Long>idList = Lists.newArrayList();
                resultRuler.forEach(urlRuler -> idList.add(urlRuler.getId()));
                entityWrapper.in("id", idList);
            }
        }
        return super.selectPage(page, entityWrapper);
    }
}
