package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.UrlTaskMapper;
import com.bxm.spider.manager.model.dao.UrlTask;
import com.bxm.spider.manager.model.dto.UrlTaskDto;
import com.bxm.spider.manager.service.service.UrlTaskService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 任务表 服务实现类
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-16
 */
@Service
public class UrlTaskServiceImpl extends ServiceImpl<UrlTaskMapper, UrlTask> implements UrlTaskService {

    @Override
    public Page<UrlTask> selectPage(UrlTaskDto urlTaskDto) {
        Page<UrlTask> page = new Page();
        page.setCurrent(urlTaskDto.getPageNum());
        page.setSize(urlTaskDto.getPageSize());

        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);

        if(StringUtils.isNotEmpty(urlTaskDto.getChannel())){
            entityWrapper.like("channel", urlTaskDto.getChannel());
        }
        if(StringUtils.isNotEmpty(urlTaskDto.getName())){
            entityWrapper.like("name", urlTaskDto.getName());
        }
        if(StringUtils.isNotEmpty(urlTaskDto.getSerialNum())){
            entityWrapper.like("serial_num", urlTaskDto.getSerialNum());
        }
        if(urlTaskDto.getExecuteStatus() != null){
            entityWrapper.eq("execute_status", urlTaskDto.getExecuteStatus());
        }

        return super.selectPage(page, entityWrapper);
    }
}
