/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisLock;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={JedisConfiguration.class})
public class JedisAutoConfiguration {
    @Autowired
    private JedisConfiguration configuration;

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }

    @Bean
    @Primary
    public JedisFetcher jedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(this.jedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisUpdater jedisUpdater() {
        JedisUpdater jedisUpdater = new JedisUpdater(this.jedisPool());
        return jedisUpdater;
    }

    @Bean
    public JedisCounter jedisCounter() {
        return new JedisCounter(this.jedisPool());
    }

    @Bean
    public JedisLock jedisLock() {
        return new JedisLock(this.jedisPool());
    }

    @Bean
    public RedisFetcher redisFetcher() {
        return new RedisFetcher(this.jedisPool());
    }

    @Bean
    @Primary
    public LoadingCacheFetcher loadingCacheFetcher() {
        return new LoadingCacheFetcher((Fetcher)this.redisFetcher());
    }
}

