/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.server.sync.zk.ZkSyncController;
import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"warcar.datasync.server"}, havingValue="true")
public class SyncControllerAutoConfiguration {
    private final DataSyncProperties properties;

    public SyncControllerAutoConfiguration(DataSyncProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnClass(value={ZkClientHolder.class})
    @Bean
    public ZkSyncController zkSyncController(ZkClientHolder zkClientHolder) {
        return new ZkSyncController(zkClientHolder, this.properties.getZkSyncPath());
    }
}

