package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.datasync.server.sync.zk.ZkSyncController;
import com.bxm.warcar.datasync.source.redis.RedisSourceController;
import org.springframework.boot.context.properties.ConfigurationProperties;


/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = DataSyncProperties.PREFIX)
public class DataSyncProperties {

    public static final String PREFIX = "warcar.datasync";
    public static final String PROPERTY_CLIENT = PREFIX + "." + "client";
    public static final String PROPERTY_SERVER = PREFIX + "." + "server";

    private boolean client;
    private boolean server;
    private Redis redis = new Redis();

    /**
     * 是否自动启动
     */
    private boolean autoStart = true;

    /**
     * ZooKeeper 的同步控制器存储节点
     */
    private String zkSyncPath = ZkSyncController.DEFAULT_PREFIX_PATH;

    public Redis getRedis() {
        return redis;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public boolean isClient() {
        return client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public boolean isServer() {
        return server;
    }

    public void setServer(boolean server) {
        this.server = server;
    }

    public boolean isAutoStart() {
        return autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getZkSyncPath() {
        return zkSyncPath;
    }

    public void setZkSyncPath(String zkSyncPath) {
        this.zkSyncPath = zkSyncPath;
    }

    public static class Redis {

        private String prefix = RedisSourceController.DEFAULT_PREFIX_KEY;
        private int db = 0;

        public String getPrefix() {
            return prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public int getDb() {
            return db;
        }

        public void setDb(int db) {
            this.db = db;
        }
    }
}
