package com.bxm.warcar.datasync.autoconfigure.client;

import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.Trigger;
import com.bxm.warcar.datasync.client.triggers.zk.ZkChildrenChangedListener;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@ConditionalOnClass({Action.class, SourceController.class})
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_CLIENT, havingValue = "true")
public class TriggerAutoConfiguration {

    private final DataSyncProperties properties;

    public TriggerAutoConfiguration(DataSyncProperties properties) {
        this.properties = properties;
    }

    @Bean
    public Trigger zkChildrenChangedListener(Action action, SourceController sourceController) {
        return new ZkChildrenChangedListener(action, sourceController);
    }

    @Bean(destroyMethod = "destroy")
    @ConditionalOnClass({ZkClientHolder.class, ZkChildrenChangedListener.class})
    public ChildrenChanged childrenChanged(ZkClientHolder zk, ZkChildrenChangedListener zkChildrenChangedListener) {
        ChildrenChanged changed = new ChildrenChanged(zk, properties.getZkSyncPath(), zkChildrenChangedListener);
        if (properties.isAutoStart()) {
            changed.init();
        }
        return changed;
    }
}
