package com.bxm.warcar.file.autoconfigure;

import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.alioss.AliOssHttpFileManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/01/29 09:50
 */
@Configuration
@EnableConfigurationProperties(HttpFileConfiguration.class)
public class HttpFileAutoConfiguration {

	@Autowired
	private HttpFileConfiguration httpFileConfiguration;

	@Bean
	public HttpFileManager httpFileManager() {
		return new AliOssHttpFileManager(httpFileConfiguration.getEndPoint(),
				httpFileConfiguration.getAccessKeyId(),
				httpFileConfiguration.getAccessKeySecret(),
				httpFileConfiguration.getHost(),
				httpFileConfiguration.getBucketName(),
				httpFileConfiguration.getServiceName(),
				httpFileConfiguration.getLimitSize());
	}

}
