/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.autoconfigure.redis;

import com.bxm.warcar.id.autoconfigure.redis.IdProperties;
import com.bxm.warcar.id.autoconfigure.redis.JedisConfiguration;
import com.bxm.warcar.id.redis.RedisAlphanumericIdGenerator;
import com.bxm.warcar.id.redis.RedisIdGenerator;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@ConditionalOnClass(value={JedisPool.class, Jedis.class})
@EnableConfigurationProperties(value={JedisConfiguration.class, IdProperties.class})
public class RedisIdGeneratorConfiguration {
    private final JedisConfiguration configuration;
    private final IdProperties idProperties;

    public RedisIdGeneratorConfiguration(JedisConfiguration jedisConfiguration, IdProperties idProperties) {
        this.configuration = jedisConfiguration;
        this.idProperties = idProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class})
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }

    @Primary
    @Bean
    public RedisIdGenerator redisIdGenerator(JedisPool jedisPool) {
        return new RedisIdGenerator(jedisPool);
    }

    @Bean
    public RedisAlphanumericIdGenerator redisAlphanumericIdGenerator(JedisPool jedisPool) {
        return new RedisAlphanumericIdGenerator(jedisPool, this.idProperties.getRedisAlphanumericIdPk());
    }
}

