/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.integration.autoconfigure.taskcounter;

import com.bxm.warcar.integration.taskcounter.TaskCountStatistics;
import com.google.common.base.Preconditions;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 1.0.0
 */
@Aspect
@Configuration
public class TaskAspectHandler {

    private final TaskCountStatistics taskMetrics;

    public TaskAspectHandler(TaskCountStatistics taskMetrics) {
        Preconditions.checkNotNull(taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    @Pointcut("@annotation(com.bxm.warcar.integration.taskcounter.TaskCounter)")
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            taskMetrics.increment();
            return point.proceed();
        } finally {
            taskMetrics.decrement();
        }
    }
}
