package com.bxm.warcar.integration.autoconfigure.distributed;

import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedLockBus;
import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * @author allen
 * @since 1.0.0
 */
public class DistributedScheduledAutoConfiguration {

    @Configuration
    @ConditionalOnClass(com.bxm.warcar.zk.ZkClientHolder.class)
    public static class ZooKeeperDistributedScheduledAutoConfiguration {

        @Bean
        @Primary
        public ZooKeeperDistributedLockBus zooKeeperDistributedLockBus(ZkClientHolder zkClientHolder) {
            return new ZooKeeperDistributedLockBus(zkClientHolder);
        }
    }
}
